<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Schematron schema for validation of authentication tokens.
    This schema is intended as a development aid for building AORTA-compliant SAML tokens.
    It is not intended as a fully functional production-quality security check.
    
    For now the queryBinding SHALL be xslt (Schematron default), because the XSG from CSC
    does not support XSLT 2.0
    This meant removal of the include xml.sch, because that heavily relies on xslt2
    
    Copyright 2008-2010, Nictiz
-->
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van SAML Assertion in een SOAP Header</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <ns uri="http://www.aortarelease.nl/805/" prefix="ao"/>
    <ns uri="http://schemas.xmlsoap.org/soap/envelope/" prefix="soap"/>
    <ns uri="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd" prefix="wsse"/>
    <ns uri="urn:oasis:names:tc:SAML:2.0:assertion" prefix="saml"/>
    <ns uri="http://www.w3.org/2000/09/xmldsig#" prefix="xmlds"/>
    <!--include href="coreschematron/xml.sch"/-->
    <pattern>
        <title>SAML Assertion</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion">
            <let name="samlId" value="concat('token_',//hl7:*[hl7:interactionId][1]/hl7:id/@root,'_',//hl7:*[hl7:interactionId][1]/hl7:id/@extension)"/>
            <assert role="error" test="@Version='2.0'">@Version moet aanwezig en de waarde '2.0' hebben</assert>
            <report role="warning" test="not(@ID=$samlId)"
                >@ID is niet opgebouwd volgens de aanbevolen methode 'token_messageIdRoot_messageIdExtension', verwacht '<value-of select="$samlId"/>'</report>
            <assert role="error" test="saml:Issuer">Issuer is verplicht</assert>
            <assert role="error" test="xmlds:Signature">Signature in de namespace 'http://www.w3.org/2000/09/xmldsig#' is verplicht</assert>
            <assert role="error" test="saml:Subject">Subject is verplicht</assert>
            <assert role="error" test="saml:Conditions">Conditions is verplicht</assert>
            <assert role="error" test="saml:AuthnStatement">AuthnStatement is verplicht</assert>
            <assert role="error" test="saml:AttributeStatement">AttributeStatement is verplicht</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML Signature</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/xmlds:Signature">
            <assert role="error" test="xmlds:KeyInfo"
                >Signature/KeyInfo is verplicht</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML Signature/Reference</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/xmlds:Signature/xmlds:SignedInfo/xmlds:Reference">
            <assert role="error" test="@URI=concat('#',/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/@ID)"
                >Signature/SignedInfo/Reference/@URI moet verwijzen naar Assertion/@ID</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML Signature/Reference/Transforms</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/xmlds:Signature/xmlds:SignedInfo/xmlds:Reference/xmlds:Transforms">
            <assert role="error" test="xmlds:Transform[@Algorithm='http://www.w3.org/2000/09/xmldsig#enveloped-signature']"
                >Signature/SignedInfo/Reference/Transforms/Transform/@Algorithm='http://www.w3.org/2000/09/xmldsig#enveloped-signature' is verplicht</assert>
            <assert role="error" test="xmlds:Transform[@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#']"
                >Signature/SignedInfo/Reference/Transforms/Transform/@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#' is verplicht</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML Subject</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:Subject">
            <assert role="error" test="starts-with(saml:NameID/text(),'urn:cert:')"
                >NameID moet beginnen met 'urn:cert:' en worden gevolgd door het seriennummer certifcaat</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML Conditions</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:Conditions">
            <let name="notBefore" value="xs:integer(format-dateTime(xs:dateTime(@NotBefore), '[Y0001][M01][D01][H01][m01][s01]', 'en', (), ()))"/>
            <let name="notOnOrAfter" value="xs:integer(format-dateTime(xs:dateTime(@NotOnOrAfter), '[Y0001][M01][D01][H01][m01][s01]', 'en', (), ()))"/>
            <assert role="error" test="$notOnOrAfter &gt; $notBefore"
                >Datum @NotBefore moet voor @NotOnOrAfter liggen</assert>
            <assert role="error" test="saml:AudienceRestriction"
                >AudienceRestriction is verplicht</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML Conditions/AudienceRestrictions/Audience</title>
        <let name="messageReceiver" value="concat('urn:IIroot:',//hl7:receiver[1]/hl7:device/hl7:id/@root,':IIext:',//hl7:receiver[1]/hl7:device/hl7:id/@extension)"/>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:Conditions[1]/saml:AudienceRestriction[1]/saml:Audience">
            <assert role="error" test="text() = $messageReceiver"
                >Audience '<value-of select="."/>' moet overeenkomen met waarde '<value-of select="$messageReceiver"/>'</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML AuthnStatement/AuthnContextClassRef</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AuthnStatement/saml:AuthnContext/saml:AuthnContextClassRef">
            <assert role="error" test=".='urn:oasis:names:tc:SAML:2.0:ac:classes:SmartcardPKI'"
                >Waarde moet 'urn:oasis:names:tc:SAML:2.0:ac:classes:SmartcardPKI' zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML AttributeStatement</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]">
            <assert role="error" test="saml:Attribute[@Name='burgerServiceNummer']/saml:AttributeValue"
                >Attribute/@Name='burgerServiceNummer' moet zijn meegetekend</assert>
            <assert role="error" test="saml:Attribute[@Name='triggerEventId']/saml:AttributeValue"
                >Attribute/@Name='triggerEventId' moet zijn meegetekend</assert>
            <assert role="error" test="saml:Attribute[@Name='messageIdExt']/saml:AttributeValue"
                >Attribute/@Name='messageIdExt' moet zijn meegetekend</assert>
            <assert role="error" test="saml:Attribute[@Name='messageIdRoot']/saml:AttributeValue"
                >Attribute/@Name='messageIdRoot' moet zijn meegetekend</assert>
        </rule>
        
        <title>SAML AttributeStatement/Attribute (burgerServiceNummer)</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]/saml:Attribute[@Name='burgerServiceNummer']/saml:AttributeValue">
            <let name="codeValue" value="text()"/>
            <let name="patientId" value="//hl7:*[@root='2.16.840.1.113883.2.4.6.3']/@extension"/>
            <assert role="error" test=". = $patientId"
                >Attribute burgerServiceNummer '<value-of select="$codeValue"/>' moet overeenkomen met verwachte waarde 
                '<value-of select="$patientId"/>'</assert>
        </rule>
        
        <title>SAML AttributeStatement/Attribute (triggerEventId)</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]/saml:Attribute[@Name='triggerEventId']/saml:AttributeValue">
            <let name="codeValue" value="text()"/>
            <let name="interactionId" value="//hl7:interactionId[1]/@extension"/>
            <!-- 
                Sinds Oxygen 11.0 met Saxon EE kun je blijkbaar geen variabelen meer aanroepen binnen een let
                Bij gebruik van onderstaande $vocabFile blijkt de concat een sequence op te leveren in plaats 
                van een string (singleton). Als je echter de inhoud van de variabele in de asserts gebruikt, 
                dan gaat alles goed. Gemeld bij Oxygen support 
            -->
            <let name="vocabFile" value="concat('../vocab/',//hl7:interactionId[1]/@root,'.xml')"/>
            <assert role="error" test="document(concat('../vocab/',//hl7:interactionId[1]/@root,'.xml'))/*/hl7:code[@code=$interactionId]/hl7:reference[@extension=$codeValue]"
                >Attribute triggerEventId '<value-of select="$codeValue"/>' moet overeenkomen met verwachte waarde 
            '<value-of select="document(concat('../vocab/',//hl7:interactionId[1]/@root,'.xml'))/*/hl7:code[@code=$interactionId]/hl7:reference/@extension"/>'</assert>
        </rule>
        
        <title>SAML AttributeStatement/Attribute (messageIdExt)</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]/saml:Attribute[@Name='messageIdExt']/saml:AttributeValue">
            <let name="codeValue" value="text()"/>
            <let name="messageIdExt" value="//hl7:*[hl7:interactionId][1]/hl7:id/@extension"/>
            <assert role="error" test="$codeValue = $messageIdExt"
                >Attribute messageIdExt '<value-of select="$codeValue"/>' moet overeenkomen met verwachte waarde '<value-of select="$messageIdExt"/>'</assert>
        </rule>
        
        <title>SAML AttributeStatement/Attribute (messageIdRoot)</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]/saml:Attribute[@Name='messageIdRoot']/saml:AttributeValue">
            <let name="codeValue" value="text()"/>
            <let name="messageIdRoot" value="//hl7:*[hl7:interactionId][1]/hl7:id/@root"/>
            <assert role="error" test="$codeValue = $messageIdRoot"
                >Attribute messageIdRoot '<value-of select="$codeValue"/>' moet overeenkomen met verwachte waarde '<value-of select="$messageIdRoot"/>'</assert>
        </rule>
    </pattern>
</schema>
